return Loaders.Base.extend({
  customInitialize: function () {
    $(".dashboardMoreActions").hide();
    $(".vHelpDropdown").hide();

    const userRole = this.user.get("user_information")?.role_ocbc?.[0];
    const projectId = this.dashboard.get("project_id");

    fetch(`/studio/status_permissions/${projectId}/viewable_roles/${userRole}`)
      .then((res) => res.json())
      .then((data) => {
        const viewableRoles = data || [];

        if (_.isEmpty(viewableRoles)) {
          window.localStorage.removeItem("additionalDashboardQuery");
        } else {
          window.localStorage.setItem(
            "additionalDashboardQuery",
            " AND (" +
              viewableRoles
                .map((role) => `uploader_role:"${role}"`)
                .join(" OR ") +
              ")",
          );
        }
      });
  },
});
