# OCtopus

Repository for the 🐙 project.

> [!IMPORTANT]
> To trigger auto deployment to `octopus-stable`, create a PR from `main` to `release` branch.

> [!IMPORTANT]
> Any changes made to `src/octopus` requires re-build of wheel file. Run
`make build` and commit the wheel file.

## Folder Structure

- `assets` contains binary files such as project exports and etc.
- `common` contains the delivery repo as submodule.
- `config` contains configuration files for the different environments.
- `dashboard` contains custom widgets for dashboard.
- `data` contains data loader plugins that is used for data loading.
- `deployment` contains deployment related scripts, tools and etc.
- `docs` contains documentation.
- `enrich` contains enrichment related pipelets.
- `integration` contains third party integrations.
- `scheduled_jobs` contains python program that is triggered by cronjobs.
- `scripts` contains various helper scripts that is used in the project.
- `src` contains the reusable OCtopus library and mocked WFI API for internal
    testing.
- `tests` contains testing related scripts and tools.

## Setup local development environment

### Python Dependencies

```bash
pip install -r requirements.txt
pre-commit install
pre-commit install --hook-type commit-msg
pip install -e .

# Alternatively
make install
```

### OS Dependencies

- `ghostscript`
  - Ubuntu: `sudo apt-get install -y ghostscript`
  - Mac: `brew install ghostscript`
  - Please refer to the [official installation guide][ghostscript] for Windows
- `pdftotext`
  - Ubuntu: `sudo apt-get install -y xpdf`
  - Mac: `brew install poppler`
  - Please refer to the [official website][pdftotext] for Windows

<!-- References -->
[ghostscript]: [https://ghostscript.readthedocs.io/en/gs10.01.1/Install.html#installing-ghostscript-on-ms-windows]
[pdftotext]: [https://www.xpdfreader.com/index.html]
