# Changelog

## [2.1.0](https://github.com/squirro/ocbc-ecoffice/compare/v2.0.0...v2.1.0) (2024-10-28)


### Features

* allow special characters in references ([#1184](https://github.com/squirro/ocbc-ecoffice/issues/1184)) ([55699c0](https://github.com/squirro/ocbc-ecoffice/commit/55699c0e71c3ee1aad9792dbe0ba581b81973398))


### Bug Fixes

* hide label on status tab if label has not been created ([#1173](https://github.com/squirro/ocbc-ecoffice/issues/1173)) ([77228f6](https://github.com/squirro/ocbc-ecoffice/commit/77228f6badbe3ccdc8460939f8a6793618a4ac06))
* item details cache ([#1176](https://github.com/squirro/ocbc-ecoffice/issues/1176)) ([0cc0e4a](https://github.com/squirro/ocbc-ecoffice/commit/0cc0e4a5f28b4f554c4ac8047f4092301366c626))
* permissions api ([#1180](https://github.com/squirro/ocbc-ecoffice/issues/1180)) ([00a4ce3](https://github.com/squirro/ocbc-ecoffice/commit/00a4ce343af1cf153cf82d3942695377eb80542c))
* redis sentinel log path ([#1175](https://github.com/squirro/ocbc-ecoffice/issues/1175)) ([75291c9](https://github.com/squirro/ocbc-ecoffice/commit/75291c957ea4ead55cb3d2eec23e978adea14c9a))
* report for wfi migrated ([#1182](https://github.com/squirro/ocbc-ecoffice/issues/1182)) ([7e2c030](https://github.com/squirro/ocbc-ecoffice/commit/7e2c030c183c30f473a21e676b1cc3a54b692e54))
* unable to update company name ([#1178](https://github.com/squirro/ocbc-ecoffice/issues/1178)) ([442e6a2](https://github.com/squirro/ocbc-ecoffice/commit/442e6a2a32a6443d0c8cfbf34f9e5d9e05318a60))
* use full name for status updates ([#1185](https://github.com/squirro/ocbc-ecoffice/issues/1185)) ([fc022c5](https://github.com/squirro/ocbc-ecoffice/commit/fc022c5c0b433be9eda233bb37a4179fd1365da8))

## 2.0.0 (2024-10-28)


### Features

* .msg file support ([#881](https://github.com/squirro/ocbc-ecoffice/issues/881)) ([cdd9191](https://github.com/squirro/ocbc-ecoffice/commit/cdd9191c00c6d10ba9f9aed0838a2f5350056e01))
* [OC-759] [MVP2] Updates to Manual Classification ([#1040](https://github.com/squirro/ocbc-ecoffice/issues/1040)) ([837dc75](https://github.com/squirro/ocbc-ecoffice/commit/837dc75395e14acfdd09d372f714e9d5b7936e4e))
* [OC-777] save to excel in documents studio plugin ([#1077](https://github.com/squirro/ocbc-ecoffice/issues/1077)) ([94b7a5e](https://github.com/squirro/ocbc-ecoffice/commit/94b7a5e574e18856f312d1eda1e4da3892e98694))
* [ODST-107] CS do not need to edit RM & CSO Name fields, but should still be able to see field value ([#1017](https://github.com/squirro/ocbc-ecoffice/issues/1017)) ([b830ae2](https://github.com/squirro/ocbc-ecoffice/commit/b830ae277797cda3f77b85675b46b5675dbce30f))
* [ODST-123] standardize viewable fields in all dashboards ([#1039](https://github.com/squirro/ocbc-ecoffice/issues/1039)) ([abe9968](https://github.com/squirro/ocbc-ecoffice/commit/abe9968ade03a0860154ee335ae6359d3e457a5a))
* [ODST-24] Set documents' initial status ([#872](https://github.com/squirro/ocbc-ecoffice/issues/872)) ([5e7d27d](https://github.com/squirro/ocbc-ecoffice/commit/5e7d27dbf3eb654ad78cb915a3c446f6cb2b88c6))
* [ODST-34] Soft-delete for 001D ([#1028](https://github.com/squirro/ocbc-ecoffice/issues/1028)) ([d4fc1cd](https://github.com/squirro/ocbc-ecoffice/commit/d4fc1cd27832c3191cf6799fd48e2058a7724c18))
* [ODST-46] new field: 'Document format' ([#969](https://github.com/squirro/ocbc-ecoffice/issues/969)) ([a1e8e35](https://github.com/squirro/ocbc-ecoffice/commit/a1e8e350695d9ab64a11cd809504620df3e44262))
* [ODST-53] set completed status for documents from wfi ([#899](https://github.com/squirro/ocbc-ecoffice/issues/899)) ([42c199d](https://github.com/squirro/ocbc-ecoffice/commit/42c199d56ef28470d3560f83626ea12ed2b67e0a))
* [ODST-68] Allow selection in items widget ([#942](https://github.com/squirro/ocbc-ecoffice/issues/942)) ([72c98fb](https://github.com/squirro/ocbc-ecoffice/commit/72c98fb3df67c96e228dbdfb66ace9419883c633))
* [ODST-82] Update Squirro items in bulk ([#943](https://github.com/squirro/ocbc-ecoffice/issues/943)) ([acc589e](https://github.com/squirro/ocbc-ecoffice/commit/acc589e323bba4905dd951d5408438e00b4bab20))
* Activity tracking IDs pipelet ([#734](https://github.com/squirro/ocbc-ecoffice/issues/734)) ([caa249b](https://github.com/squirro/ocbc-ecoffice/commit/caa249b12c63a651aaca6bc0162800b8385b78d0))
* Add ageing days column in reports ([#989](https://github.com/squirro/ocbc-ecoffice/issues/989)) ([1604723](https://github.com/squirro/ocbc-ecoffice/commit/160472365a65d6e2ad18aee743d7fd6ad3b4ab70))
* add cso name column for WIP dashboard ([#915](https://github.com/squirro/ocbc-ecoffice/issues/915)) ([d0679b9](https://github.com/squirro/ocbc-ecoffice/commit/d0679b97f9cbf272724fc87838abefff20dbfb77))
* Add generate label action ([#980](https://github.com/squirro/ocbc-ecoffice/issues/980)) ([77d9794](https://github.com/squirro/ocbc-ecoffice/commit/77d9794c055acd8c969da89e54edc5e7a44876d9))
* Add references column in list view ([#814](https://github.com/squirro/ocbc-ecoffice/issues/814)) ([07d1bd5](https://github.com/squirro/ocbc-ecoffice/commit/07d1bd59f7cbfa798a1d6f6836f64f160be254f9))
* Add status tracking panel to items widget ([#887](https://github.com/squirro/ocbc-ecoffice/issues/887)) ([ae5948f](https://github.com/squirro/ocbc-ecoffice/commit/ae5948fad81de9a2c2257e648833eb45a14626c8))
* Add upload date time to label generation ([#1029](https://github.com/squirro/ocbc-ecoffice/issues/1029)) ([8ff0ba4](https://github.com/squirro/ocbc-ecoffice/commit/8ff0ba44fd9cb6c005842c2d21b0d55a2b8d2ead))
* allow re-uploading of soft-deleted items ([#966](https://github.com/squirro/ocbc-ecoffice/issues/966)) ([18d15ce](https://github.com/squirro/ocbc-ecoffice/commit/18d15cea700179479fc0e873bb6420ec42de8ba5))
* ansible controlled cronjobs ([#1051](https://github.com/squirro/ocbc-ecoffice/issues/1051)) ([e0f4b8f](https://github.com/squirro/ocbc-ecoffice/commit/e0f4b8f53e7d4bd96c0e3babef01bfb3eea0cbb0))
* auto-tag rm name based on detected company name ([#941](https://github.com/squirro/ocbc-ecoffice/issues/941)) ([6fff26a](https://github.com/squirro/ocbc-ecoffice/commit/6fff26af34fff541c261eddba38a56f9e82c297d))
* autocomplete for cso and rm names; allow editing of cso names on frontend with autocomplete dropdown ([#866](https://github.com/squirro/ocbc-ecoffice/issues/866)) ([7354f26](https://github.com/squirro/ocbc-ecoffice/commit/7354f26103ff21af5eb5bd360752967e40ebbe74))
* Change background colour ([#785](https://github.com/squirro/ocbc-ecoffice/issues/785)) ([3306a8b](https://github.com/squirro/ocbc-ecoffice/commit/3306a8b74a5e7284ba084fa03cb3c0faa1fd808c))
* company data enrichment ([#715](https://github.com/squirro/ocbc-ecoffice/issues/715)) ([510d5d7](https://github.com/squirro/ocbc-ecoffice/commit/510d5d73a878d246d4bb3cff198dea4c9cb02207))
* company names autocomplete with cifs ([#879](https://github.com/squirro/ocbc-ecoffice/issues/879)) ([6af30ff](https://github.com/squirro/ocbc-ecoffice/commit/6af30ff4a442cf500681e7a3fd65e7f72cb6d8ee))
* Create RM and Ops group on deployment ([#882](https://github.com/squirro/ocbc-ecoffice/issues/882)) ([8652859](https://github.com/squirro/ocbc-ecoffice/commit/8652859d7e3e3c3c700fd98cc37ec9da56d7d43a))
* Create script to rename datasource ([#782](https://github.com/squirro/ocbc-ecoffice/issues/782)) ([ed6bcb7](https://github.com/squirro/ocbc-ecoffice/commit/ed6bcb7c9f346dee042abbac2fa2633963f9385c))
* date extraction ([#877](https://github.com/squirro/ocbc-ecoffice/issues/877)) ([4b0875c](https://github.com/squirro/ocbc-ecoffice/commit/4b0875cd045b6c4901c86aa105e550faa37ae8c7))
* decorator for squirro client ([535a641](https://github.com/squirro/ocbc-ecoffice/commit/535a641bc260070461af1ead8f87a32f8e950a07))
* decorator to load config ([ec049c0](https://github.com/squirro/ocbc-ecoffice/commit/ec049c06c095c9e5a4bac86ec17a9161e5ce5809))
* document status backend ([#791](https://github.com/squirro/ocbc-ecoffice/issues/791)) ([0d6c5df](https://github.com/squirro/ocbc-ecoffice/commit/0d6c5df3b89151e2b1464832c65d6fc82b4d3b8b))
* duplicate handling ([#696](https://github.com/squirro/ocbc-ecoffice/issues/696)) ([4cede91](https://github.com/squirro/ocbc-ecoffice/commit/4cede91b8f0195fb81160b0db38b24e634d0bf68))
* email notification for status tracking ([#939](https://github.com/squirro/ocbc-ecoffice/issues/939)) ([570a713](https://github.com/squirro/ocbc-ecoffice/commit/570a7137eeac74f381aa9dbe90c12025dc8e48ec))
* expose project id along with squirro client ([1cd35f8](https://github.com/squirro/ocbc-ecoffice/commit/1cd35f85ffbda1f7fe8f60ead28b9189134c71da))
* force ocr ([#700](https://github.com/squirro/ocbc-ecoffice/issues/700)) ([ab538c0](https://github.com/squirro/ocbc-ecoffice/commit/ab538c07aebd8c56c883dbd06ca76c2c5ddb0ebd))
* Generate batch reports ([#955](https://github.com/squirro/ocbc-ecoffice/issues/955)) ([9d4a4fb](https://github.com/squirro/ocbc-ecoffice/commit/9d4a4fb7c5a115059180dbb340e1f16eea0fad02))
* Hide delete icon for non-admins ([#771](https://github.com/squirro/ocbc-ecoffice/issues/771)) ([c6a0671](https://github.com/squirro/ocbc-ecoffice/commit/c6a067136967d0597b3e7f6e447c210bc642c470))
* Include more info in login stats excel export ([#953](https://github.com/squirro/ocbc-ecoffice/issues/953)) ([de46a57](https://github.com/squirro/ocbc-ecoffice/commit/de46a57eddf64b1e055b1a3d17e07f610bc60bc1))
* initial setup playbook to prepare for octopus and initialize vault ([#992](https://github.com/squirro/ocbc-ecoffice/issues/992)) ([e5bc8b4](https://github.com/squirro/ocbc-ecoffice/commit/e5bc8b4262867c8f9f2ea37c3fc0b7c05b92691b))
* logout page with qualtrics ([#776](https://github.com/squirro/ocbc-ecoffice/issues/776)) ([1544685](https://github.com/squirro/ocbc-ecoffice/commit/15446851503b1956d625dc791607fba55dfdc60e))
* Make num outstanding days configurable for batch reports ([#1032](https://github.com/squirro/ocbc-ecoffice/issues/1032)) ([8e55e33](https://github.com/squirro/ocbc-ecoffice/commit/8e55e333abeece7d9b166a146f823e16c1b8c264))
* Map the references label ([#739](https://github.com/squirro/ocbc-ecoffice/issues/739)) ([8085716](https://github.com/squirro/ocbc-ecoffice/commit/8085716bdf23e15a28ce1e8b8f39f9c5599b0dd6))
* odst-1 latest status transitions ([#905](https://github.com/squirro/ocbc-ecoffice/issues/905)) ([0d23ed4](https://github.com/squirro/ocbc-ecoffice/commit/0d23ed4fa2aa04a4c21e4d6f1d411f9e8b984f4e))
* odst-18 label generation ([#971](https://github.com/squirro/ocbc-ecoffice/issues/971)) ([54876bf](https://github.com/squirro/ocbc-ecoffice/commit/54876bf69c751638262e3dee83d6ab37736e2ee4))
* odst-20 plugin api for bulk status update ([#937](https://github.com/squirro/ocbc-ecoffice/issues/937)) ([cbeb8ab](https://github.com/squirro/ocbc-ecoffice/commit/cbeb8ab70300a28864625ec4e7e69f89d998fb7c))
* odst-45 check uploader role for document create ([#871](https://github.com/squirro/ocbc-ecoffice/issues/871)) ([f28057d](https://github.com/squirro/ocbc-ecoffice/commit/f28057ddf69668f7f4e682fbd05f00a77616d05e))
* odst-47 authorization for dual role holders ([#873](https://github.com/squirro/ocbc-ecoffice/issues/873)) ([89cbe86](https://github.com/squirro/ocbc-ecoffice/commit/89cbe86a7460c4fe6b5fd2841c66bd7d604b9d04))
* odst-64 set header as label for filtering ([#913](https://github.com/squirro/ocbc-ecoffice/issues/913)) ([dbbe684](https://github.com/squirro/ocbc-ecoffice/commit/dbbe684803fe86940e5ceb0750997b3b187ac611))
* odst-66 coverity does not allow to read envvars ([#927](https://github.com/squirro/ocbc-ecoffice/issues/927)) ([620d020](https://github.com/squirro/ocbc-ecoffice/commit/620d020bbaac85fd319c8e4ae75d3f15512d5ef3))
* odst-8 only admins can update project config ([#870](https://github.com/squirro/ocbc-ecoffice/issues/870)) ([2676c7a](https://github.com/squirro/ocbc-ecoffice/commit/2676c7a5306eda8ad5f4e87fbba2a1748e66f724))
* Online reports ([#956](https://github.com/squirro/ocbc-ecoffice/issues/956)) ([62abd5b](https://github.com/squirro/ocbc-ecoffice/commit/62abd5b2d85b5db2cf850b54ffb07d4f77a58353))
* online zip extraction ([#983](https://github.com/squirro/ocbc-ecoffice/issues/983)) ([#1150](https://github.com/squirro/ocbc-ecoffice/issues/1150)) ([6f03af7](https://github.com/squirro/ocbc-ecoffice/commit/6f03af7feb88490e3d08e6901bfa70bb528ed8e5))
* Permissions frontend for WIP ([#1018](https://github.com/squirro/ocbc-ecoffice/issues/1018)) ([fc3ac67](https://github.com/squirro/ocbc-ecoffice/commit/fc3ac677c4de12148f214567a99c663520ba98c0))
* prevent PEP 420 warnings from flooding logs ([#1068](https://github.com/squirro/ocbc-ecoffice/issues/1068)) ([e0504c5](https://github.com/squirro/ocbc-ecoffice/commit/e0504c5c25bc7c9cce78249097c1d8b7690e15a5))
* redis client ([adf3ff2](https://github.com/squirro/ocbc-ecoffice/commit/adf3ff2ff07b20b1ebbac33a3501bfcf05a9c7b1))
* reject password protected office files ([#976](https://github.com/squirro/ocbc-ecoffice/issues/976)) ([bf60274](https://github.com/squirro/ocbc-ecoffice/commit/bf60274f897f8301a7012b9b0c3d663ace25a812))
* Reports change requests ([#1019](https://github.com/squirro/ocbc-ecoffice/issues/1019)) ([f956592](https://github.com/squirro/ocbc-ecoffice/commit/f95659200b2901b347830427370a3be54907f8a5))
* Script to retag items (SLO to LO) ([#775](https://github.com/squirro/ocbc-ecoffice/issues/775)) ([24ec60a](https://github.com/squirro/ocbc-ecoffice/commit/24ec60a0ecd05ef77925ce8356c8cf0f9c1fbb8a))
* Show current status header in list view and filters ([#920](https://github.com/squirro/ocbc-ecoffice/issues/920)) ([46e1376](https://github.com/squirro/ocbc-ecoffice/commit/46e1376eccfd694eb03eff29bbc532a2f2fb5685))
* Show num pages on UI ([#781](https://github.com/squirro/ocbc-ecoffice/issues/781)) ([779e814](https://github.com/squirro/ocbc-ecoffice/commit/779e8142393d65c0a6ffbe33b466ade3525c9856))
* Show pending status in ingestion dashboard ([#901](https://github.com/squirro/ocbc-ecoffice/issues/901)) ([4f18da4](https://github.com/squirro/ocbc-ecoffice/commit/4f18da44dc99f67f84fc6ee297d72fff96937b4b))
* Show user login stats in monitoring ([#827](https://github.com/squirro/ocbc-ecoffice/issues/827)) ([1e1465a](https://github.com/squirro/ocbc-ecoffice/commit/1e1465a155108094027b4779f648e01167b12eab))
* Sort by title in reference screen ([#772](https://github.com/squirro/ocbc-ecoffice/issues/772)) ([fd02b82](https://github.com/squirro/ocbc-ecoffice/commit/fd02b827a26b6043a2e37587d28a8759c11029da))
* special handling of 001Z to 003B ([#1050](https://github.com/squirro/ocbc-ecoffice/issues/1050)) ([f272d49](https://github.com/squirro/ocbc-ecoffice/commit/f272d49481b2f1ad0eaa41e06b6dae685884b85a))
* Store into WFI ([#714](https://github.com/squirro/ocbc-ecoffice/issues/714)) ([740b8d4](https://github.com/squirro/ocbc-ecoffice/commit/740b8d4b4cda3748445d67aab09cbbaef0baea7b))
* store number of pages as metadata ([#779](https://github.com/squirro/ocbc-ecoffice/issues/779)) ([3c3d4f9](https://github.com/squirro/ocbc-ecoffice/commit/3c3d4f937edaa01b78af418825bf4cd06f408e08))
* Store the original WFI ID on all documents from WFI ([#742](https://github.com/squirro/ocbc-ecoffice/issues/742)) ([f2847b0](https://github.com/squirro/ocbc-ecoffice/commit/f2847b06650ff00626db925a703818ee52291c1f))
* Store two roles inside user_information ([#921](https://github.com/squirro/ocbc-ecoffice/issues/921)) ([004471f](https://github.com/squirro/ocbc-ecoffice/commit/004471f2997782563a004dbafd12d38e85e94260))
* text pre-processing utils ([7e61069](https://github.com/squirro/ocbc-ecoffice/commit/7e61069c29edbd5fd0ebb11b94d1fa4c22506613))
* Track items from WFI and show in dashboard ([#836](https://github.com/squirro/ocbc-ecoffice/issues/836)) ([b4c10c5](https://github.com/squirro/ocbc-ecoffice/commit/b4c10c548f2634187780785b61a237783c144efe))
* Track Items in Redis ([#718](https://github.com/squirro/ocbc-ecoffice/issues/718)) ([be6b512](https://github.com/squirro/ocbc-ecoffice/commit/be6b512ca85e28fa9f9889626d07afc54d57eeeb))
* Track rejected items in redis ([#727](https://github.com/squirro/ocbc-ecoffice/issues/727)) ([a8a26f9](https://github.com/squirro/ocbc-ecoffice/commit/a8a26f96f856ca0994a3c00aac891b0f1dd61a3c))
* Update document types mapping ([#773](https://github.com/squirro/ocbc-ecoffice/issues/773)) ([ce2659f](https://github.com/squirro/ocbc-ecoffice/commit/ce2659fc0c74770cf3153de5c634eb84e5d3ef74))
* Update query template for Ops users ([#910](https://github.com/squirro/ocbc-ecoffice/issues/910)) ([b8cb100](https://github.com/squirro/ocbc-ecoffice/commit/b8cb100d6ec63ed286eae2672e5f5bfa65ca7c89))
* Update status when labels are changed ([#874](https://github.com/squirro/ocbc-ecoffice/issues/874)) ([a2e0d2f](https://github.com/squirro/ocbc-ecoffice/commit/a2e0d2f7a154c8ca613c4545863a1ef5a8625d00))
* Update WFI to Squirro doc type mapping ([#793](https://github.com/squirro/ocbc-ecoffice/issues/793)) ([5d04fcf](https://github.com/squirro/ocbc-ecoffice/commit/5d04fcff27a584da0d31d9847c4d58b5df8811c3))
* Upload WFI IDs from UI ([#740](https://github.com/squirro/ocbc-ecoffice/issues/740)) ([8d62b9e](https://github.com/squirro/ocbc-ecoffice/commit/8d62b9e588688b37993874b4dc41e5b361cdb46d))
* Validate reference field ([#886](https://github.com/squirro/ocbc-ecoffice/issues/886)) ([16df6c2](https://github.com/squirro/ocbc-ecoffice/commit/16df6c22601949628016174e26a6db1952019176))
* Wfi client ([#711](https://github.com/squirro/ocbc-ecoffice/issues/711)) ([695a7a0](https://github.com/squirro/ocbc-ecoffice/commit/695a7a02787468cfae02377dd0555d510537a793))
* WFI loader periodic W segment ([#760](https://github.com/squirro/ocbc-ecoffice/issues/760)) ([fe9f5b7](https://github.com/squirro/ocbc-ecoffice/commit/fe9f5b7dad4e18f5134ba214e872b4799622e166))
* wfi soft delete and restore integration ([#1046](https://github.com/squirro/ocbc-ecoffice/issues/1046)) ([5443b35](https://github.com/squirro/ocbc-ecoffice/commit/5443b350cf5b40bfdaea8efb222215a796ae2713))
* WIP dashboard ([#883](https://github.com/squirro/ocbc-ecoffice/issues/883)) ([cdefa4f](https://github.com/squirro/ocbc-ecoffice/commit/cdefa4f57a2df01071c8b770a979bf332db6143e))


### Bug Fixes

* [OC-707] include disclaimer for emails sent from non-prod env ([#967](https://github.com/squirro/ocbc-ecoffice/issues/967)) ([757c929](https://github.com/squirro/ocbc-ecoffice/commit/757c929da53ccf228343f7872fbdb0682961114f))
* [OC-781] include logic to allow edit Document Format in WIP Dashboard ([#1062](https://github.com/squirro/ocbc-ecoffice/issues/1062)) ([cbe14c1](https://github.com/squirro/ocbc-ecoffice/commit/cbe14c1c32f2ddbc03fae33434877009dbea204a))
* [ODST-108] disable upload dashboard for rm ([#978](https://github.com/squirro/ocbc-ecoffice/issues/978)) ([478f3eb](https://github.com/squirro/ocbc-ecoffice/commit/478f3eb0777ba2dd30542070ca27b1c1b36e2d63))
* [ODST-122] Updates to Document Format Fields ([#1016](https://github.com/squirro/ocbc-ecoffice/issues/1016)) ([11012da](https://github.com/squirro/ocbc-ecoffice/commit/11012da080467b2dcffcf7a1cac3b23c7a05ac88))
* [ODST-16] duplicated downlload icon ([#977](https://github.com/squirro/ocbc-ecoffice/issues/977)) ([5a11ab2](https://github.com/squirro/ocbc-ecoffice/commit/5a11ab2ac928d03d349459e4dd313cc23671bc0b))
* 0 bytes pdf due to indentation ([#1136](https://github.com/squirro/ocbc-ecoffice/issues/1136)) ([96bcae8](https://github.com/squirro/ocbc-ecoffice/commit/96bcae881ca79551b4e77f7e8a34fe7ee2987281))
* add .pdf as file extension ([#1131](https://github.com/squirro/ocbc-ecoffice/issues/1131)) ([8f853e9](https://github.com/squirro/ocbc-ecoffice/commit/8f853e98f6291f80bb4d88ed3870dd07c96e5865))
* Add document format to status export pdf ([#1112](https://github.com/squirro/ocbc-ecoffice/issues/1112)) ([3c073b9](https://github.com/squirro/ocbc-ecoffice/commit/3c073b9453d90362f902f4a3b174c057925f4ad9))
* Add rejection reason in ingestion excel export ([#904](https://github.com/squirro/ocbc-ecoffice/issues/904)) ([4f7d673](https://github.com/squirro/ocbc-ecoffice/commit/4f7d673a8181a711f693db0ce4b391b1da034efa))
* Add wfi_document_date to reader keywords ([#923](https://github.com/squirro/ocbc-ecoffice/issues/923)) ([6fdb3e0](https://github.com/squirro/ocbc-ecoffice/commit/6fdb3e00147dea2d6d8757cca537fddfa7209de5))
* Allow CS Maker Checker to access status tracking ([#948](https://github.com/squirro/ocbc-ecoffice/issues/948)) ([e2da249](https://github.com/squirro/ocbc-ecoffice/commit/e2da2499efde85b858dd8d88d828bbfbf88f50d0))
* breakdown db into ip and password in vault ([#986](https://github.com/squirro/ocbc-ecoffice/issues/986)) ([741c2fd](https://github.com/squirro/ocbc-ecoffice/commit/741c2fdf21ec34cf117226d0404a9806032ff854))
* cache company data scan config mismatch ([#853](https://github.com/squirro/ocbc-ecoffice/issues/853)) ([6a2f4a5](https://github.com/squirro/ocbc-ecoffice/commit/6a2f4a5acd1b116d14ef663ed74ef7ecffca9e9d))
* Change retry period from 72h to 24h ([bae231f](https://github.com/squirro/ocbc-ecoffice/commit/bae231f3fa52e8675ffc4b09bcc8e78320a1f8ca))
* Check status of all documents during bulk assignment ([#947](https://github.com/squirro/ocbc-ecoffice/issues/947)) ([ca6f9d8](https://github.com/squirro/ocbc-ecoffice/commit/ca6f9d8ec582d564770d6c89042b761ef047ff04))
* clean-dangling script writes to root when no current dir ([#729](https://github.com/squirro/ocbc-ecoffice/issues/729)) ([8e43bef](https://github.com/squirro/ocbc-ecoffice/commit/8e43bef0cf0426d7845a62ae7dac732b55c09301))
* company file empty values ([#1144](https://github.com/squirro/ocbc-ecoffice/issues/1144)) ([ca78e8b](https://github.com/squirro/ocbc-ecoffice/commit/ca78e8b5d364eb2fed49412e002ccd164714dc3e))
* Convert time to local time in email notifications ([#902](https://github.com/squirro/ocbc-ecoffice/issues/902)) ([3e7057c](https://github.com/squirro/ocbc-ecoffice/commit/3e7057cf9e436b2e92d3d161fe3a2f7993411eab))
* Convert time to UTC before sending request ([#1001](https://github.com/squirro/ocbc-ecoffice/issues/1001)) ([2909e24](https://github.com/squirro/ocbc-ecoffice/commit/2909e240bc0aa5d5262990469d28f3dd69ef4dd1))
* country is none if lan_id does not exists ([#963](https://github.com/squirro/ocbc-ecoffice/issues/963)) ([ea7c2c3](https://github.com/squirro/ocbc-ecoffice/commit/ea7c2c38c1c8586c49ad449230fad3043c87863f))
* coverity 20241007 ([#1168](https://github.com/squirro/ocbc-ecoffice/issues/1168)) ([f38288c](https://github.com/squirro/ocbc-ecoffice/commit/f38288cc573e737a435248f9febd2f06887b74d9))
* covert timestamp in status map to be local time ([#916](https://github.com/squirro/ocbc-ecoffice/issues/916)) ([232af84](https://github.com/squirro/ocbc-ecoffice/commit/232af846f537437476685cc5c46474534c072afb))
* create labels on monitoring project ([#1067](https://github.com/squirro/ocbc-ecoffice/issues/1067)) ([b15f3e1](https://github.com/squirro/ocbc-ecoffice/commit/b15f3e10a535b3383ca71cd193f218ff543436e8))
* cron job vault issues ([#1074](https://github.com/squirro/ocbc-ecoffice/issues/1074)) ([e4a552a](https://github.com/squirro/ocbc-ecoffice/commit/e4a552a7d8894f75fa5ee2001a8f413d3583d471))
* Dashboards and project exports related ([#1061](https://github.com/squirro/ocbc-ecoffice/issues/1061)) ([844dcb1](https://github.com/squirro/ocbc-ecoffice/commit/844dcb12416496e9458d9c38df93cea6b67d3961))
* db object not available in background thread ([#1071](https://github.com/squirro/ocbc-ecoffice/issues/1071)) ([e370f52](https://github.com/squirro/ocbc-ecoffice/commit/e370f527f136c4a94194ab2615a9dd0676d41b51))
* disable status 001F for CSO checker ([#961](https://github.com/squirro/ocbc-ecoffice/issues/961)) ([f9c045b](https://github.com/squirro/ocbc-ecoffice/commit/f9c045bf3456e5a94bd9afadff2afda5966081a3))
* do not fail if territory list and company file not found ([#1139](https://github.com/squirro/ocbc-ecoffice/issues/1139)) ([29ae989](https://github.com/squirro/ocbc-ecoffice/commit/29ae989d2b620e9a39e2216ec416e96a7c639f5c))
* Do not retry for 400 ([#792](https://github.com/squirro/ocbc-ecoffice/issues/792)) ([4163150](https://github.com/squirro/ocbc-ecoffice/commit/4163150a2a9da0d37bf6ab7165250e3bde97b069))
* Do not retry to prevent multiple entries in the status retry queue ([#1013](https://github.com/squirro/ocbc-ecoffice/issues/1013)) ([c75be63](https://github.com/squirro/ocbc-ecoffice/commit/c75be6307081086b087755de16b3ffe0c4d3943f))
* Do not update keywords for ATXXX codes ([#985](https://github.com/squirro/ocbc-ecoffice/issues/985)) ([36ed071](https://github.com/squirro/ocbc-ecoffice/commit/36ed071845a5184c68e2efcb2cac44c904456dfe))
* document name nullable ([#964](https://github.com/squirro/ocbc-ecoffice/issues/964)) ([c182b96](https://github.com/squirro/ocbc-ecoffice/commit/c182b960985c4c5858aa172fd64f596b5a56377f))
* dr deployment ([#1154](https://github.com/squirro/ocbc-ecoffice/issues/1154)) ([4780171](https://github.com/squirro/ocbc-ecoffice/commit/4780171cc14136df8667a2c07cb3693c139e02ae))
* dual role always show as maker ([#960](https://github.com/squirro/ocbc-ecoffice/issues/960)) ([6ff969c](https://github.com/squirro/ocbc-ecoffice/commit/6ff969c7d5daf32b20d46d466b37553c12660a74))
* dual role restriction on 001 to 001Z ([#1044](https://github.com/squirro/ocbc-ecoffice/issues/1044)) ([4d37f0d](https://github.com/squirro/ocbc-ecoffice/commit/4d37f0d5f64c7f361a342767c0995316f498640e))
* **duplicate-handling:** Labels cannot be bool ([#741](https://github.com/squirro/ocbc-ecoffice/issues/741)) ([691c55a](https://github.com/squirro/ocbc-ecoffice/commit/691c55a69cfc149ca331ab0f0c2e767ca81ea18d))
* edit and delete permission user restriction now case insensitive ([#1109](https://github.com/squirro/ocbc-ecoffice/issues/1109)) ([9aeb9b7](https://github.com/squirro/ocbc-ecoffice/commit/9aeb9b708241079fdc34863691519ed772adeef3))
* email does not send to multiple receiver ([#987](https://github.com/squirro/ocbc-ecoffice/issues/987)) ([c0ecc01](https://github.com/squirro/ocbc-ecoffice/commit/c0ecc01c326f50c04f7c2d8b0ca6cba9e8b45d6c))
* es cert true ([#1165](https://github.com/squirro/ocbc-ecoffice/issues/1165)) ([f569087](https://github.com/squirro/ocbc-ecoffice/commit/f569087f3d788225c60700ef79b621eef52e51b0))
* es certs ([#1100](https://github.com/squirro/ocbc-ecoffice/issues/1100)) ([d616fff](https://github.com/squirro/ocbc-ecoffice/commit/d616fff842458df848d019117064781a029e786c))
* es certs ([#1158](https://github.com/squirro/ocbc-ecoffice/issues/1158)) ([3bda22e](https://github.com/squirro/ocbc-ecoffice/commit/3bda22edba7ee430d6448ac40a6d153c843467b6))
* es client wrong section ([#932](https://github.com/squirro/ocbc-ecoffice/issues/932)) ([f1a682b](https://github.com/squirro/ocbc-ecoffice/commit/f1a682b64bc8e8ed050b9a23b54b09d770c0136a))
* Export menu not shown ([#1003](https://github.com/squirro/ocbc-ecoffice/issues/1003)) ([ea31f86](https://github.com/squirro/ocbc-ecoffice/commit/ea31f86ca07a80f661415bbfceedf2bd60069fb9))
* **extract-zip-pipelet:** extension should not be case sensitive ([#878](https://github.com/squirro/ocbc-ecoffice/issues/878)) ([d67ae4d](https://github.com/squirro/ocbc-ecoffice/commit/d67ae4d314194dd1f800788a16b8df452f0019c6))
* false positive on password protected pdf that are able to open ([#787](https://github.com/squirro/ocbc-ecoffice/issues/787)) ([c65a43e](https://github.com/squirro/ocbc-ecoffice/commit/c65a43eddebb40c5e609d5e6cb1e26e9d814d5a1))
* filter items config and client ([#746](https://github.com/squirro/ocbc-ecoffice/issues/746)) ([c957951](https://github.com/squirro/ocbc-ecoffice/commit/c957951fe3c7d4041d4c4cc866c79ddcbe0ec52b))
* Fix authorisation script path ([#876](https://github.com/squirro/ocbc-ecoffice/issues/876)) ([dda1e88](https://github.com/squirro/ocbc-ecoffice/commit/dda1e88e93c0baf5c966d941d3ca192239f45123))
* Fix BBCA Reference typo ([#850](https://github.com/squirro/ocbc-ecoffice/issues/850)) ([e42d291](https://github.com/squirro/ocbc-ecoffice/commit/e42d2915f7f41e2738c7013bff82ecba49f9ad57))
* Fix cannot edit labels from item detail view ([#919](https://github.com/squirro/ocbc-ecoffice/issues/919)) ([edd059f](https://github.com/squirro/ocbc-ecoffice/commit/edd059ff8cc6ec2f1a16902b7f24462bd6079888))
* Fix cover page text in columns overlapping ([#1084](https://github.com/squirro/ocbc-ecoffice/issues/1084)) ([0b1ce49](https://github.com/squirro/ocbc-ecoffice/commit/0b1ce49892e63df0f594e68e5b41d14b3db1c02e))
* Fix CS role names in config ([#1045](https://github.com/squirro/ocbc-ecoffice/issues/1045)) ([386f856](https://github.com/squirro/ocbc-ecoffice/commit/386f8567d94ee9111b3545b547d18b2c4df890e3))
* Fix empty reference showing on item ([#761](https://github.com/squirro/ocbc-ecoffice/issues/761)) ([4d79a89](https://github.com/squirro/ocbc-ecoffice/commit/4d79a89cf8408f30410e7ce9f43239ef6ae9605d))
* Fix incorrect date formats ([#1042](https://github.com/squirro/ocbc-ecoffice/issues/1042)) ([0b53376](https://github.com/squirro/ocbc-ecoffice/commit/0b53376908c01e80246660501918639f98f604f6))
* Fix internal doc bbca naming ([#839](https://github.com/squirro/ocbc-ecoffice/issues/839)) ([1a7b175](https://github.com/squirro/ocbc-ecoffice/commit/1a7b1758c29d3e225e48053d9dea85c381270820))
* Fix key error ([#944](https://github.com/squirro/ocbc-ecoffice/issues/944)) ([3a21f0b](https://github.com/squirro/ocbc-ecoffice/commit/3a21f0b3d15c7b3408ab71eb3d102e2c327ac1cf))
* Fix labels not updating if there is no initial value ([#949](https://github.com/squirro/ocbc-ecoffice/issues/949)) ([157f296](https://github.com/squirro/ocbc-ecoffice/commit/157f296d0ef0214feaeefa591c28c7fb6ee93604))
* Fix login info not displayed on first load ([#952](https://github.com/squirro/ocbc-ecoffice/issues/952)) ([fc916df](https://github.com/squirro/ocbc-ecoffice/commit/fc916dfe335b7e7ed3ea094c2da8a065d496b1dd))
* Fix logs and source squirro-python ([#795](https://github.com/squirro/ocbc-ecoffice/issues/795)) ([30307a5](https://github.com/squirro/ocbc-ecoffice/commit/30307a5b05b96bc6c2ca4cfea4a0416e40bfd273))
* Fix mismatch between pipelet and studio plugin to set initial status ([#885](https://github.com/squirro/ocbc-ecoffice/issues/885)) ([63fc93d](https://github.com/squirro/ocbc-ecoffice/commit/63fc93dc8e19118c06c66b388be9b7b561b120af))
* Fix no emails being sent ([#829](https://github.com/squirro/ocbc-ecoffice/issues/829)) ([1f8c76f](https://github.com/squirro/ocbc-ecoffice/commit/1f8c76f0efa0905406f7574e4c8c1b8ea7fd88ff))
* Fix normal user unable to update company name ([#1007](https://github.com/squirro/ocbc-ecoffice/issues/1007)) ([209e4b0](https://github.com/squirro/ocbc-ecoffice/commit/209e4b07c16b6b8348d1966623d0e840dcf0c78b))
* Fix online report widget ([#999](https://github.com/squirro/ocbc-ecoffice/issues/999)) ([f4e0b94](https://github.com/squirro/ocbc-ecoffice/commit/f4e0b9411020f487dc58e341dec311d6b71ff12f))
* Fix overlay not covering the entire form ([#1147](https://github.com/squirro/ocbc-ecoffice/issues/1147)) ([665f09c](https://github.com/squirro/ocbc-ecoffice/commit/665f09ca64abe4a31a8a661a2c7a5ac6f53bfcb5))
* Fix project export script ([#860](https://github.com/squirro/ocbc-ecoffice/issues/860)) ([98b83d6](https://github.com/squirro/ocbc-ecoffice/commit/98b83d69c5445ccc0e310d57e6aca824b3b5c33f))
* Fix project id error ([#744](https://github.com/squirro/ocbc-ecoffice/issues/744)) ([aaf6719](https://github.com/squirro/ocbc-ecoffice/commit/aaf67195debd324726c88eae467375acd545b943))
* Fix query in save to excel ([#1085](https://github.com/squirro/ocbc-ecoffice/issues/1085)) ([3e2db43](https://github.com/squirro/ocbc-ecoffice/commit/3e2db43294e097fa16ecc255c16810d8dad9a802))
* Fix reference screen not showing ([#924](https://github.com/squirro/ocbc-ecoffice/issues/924)) ([0dc59de](https://github.com/squirro/ocbc-ecoffice/commit/0dc59de7b83cc1630cf55eafc259d6b23e20da5a))
* Fix reference view breaking for list view ([#1155](https://github.com/squirro/ocbc-ecoffice/issues/1155)) ([b489626](https://github.com/squirro/ocbc-ecoffice/commit/b4896261bf6e13e1de707172e73d1881a7ddf1a9))
* Fix references not showing in excel export ([#849](https://github.com/squirro/ocbc-ecoffice/issues/849)) ([133749d](https://github.com/squirro/ocbc-ecoffice/commit/133749d369b7fda40ce6feeaad0b6a3a017aed36))
* Fix RM unable to generate report ([#1069](https://github.com/squirro/ocbc-ecoffice/issues/1069)) ([2690d93](https://github.com/squirro/ocbc-ecoffice/commit/2690d93e65b2448900844d6f980933f74481a4e0))
* Fix same filters for statuses applied twice ([#1056](https://github.com/squirro/ocbc-ecoffice/issues/1056)) ([15b422b](https://github.com/squirro/ocbc-ecoffice/commit/15b422bd44351db9763c5056be4dd9c987319412))
* Fix SQL syntax for batch reports ([#1122](https://github.com/squirro/ocbc-ecoffice/issues/1122)) ([b906c01](https://github.com/squirro/ocbc-ecoffice/commit/b906c0160c115ff9decfb87ccfcdff01fb1d0f7d))
* Fix SSO variable name error ([#889](https://github.com/squirro/ocbc-ecoffice/issues/889)) ([4e051e7](https://github.com/squirro/ocbc-ecoffice/commit/4e051e7b9d6e0f9988e844ea68e5cc853dc10791))
* Fix status form disappearing after discarding ([#934](https://github.com/squirro/ocbc-ecoffice/issues/934)) ([0f57acc](https://github.com/squirro/ocbc-ecoffice/commit/0f57acc075e9020beeede37e75e0caca782d21ab))
* Fix status not set for WFI migrated docs ([#994](https://github.com/squirro/ocbc-ecoffice/issues/994)) ([b107114](https://github.com/squirro/ocbc-ecoffice/commit/b107114636957f6c3aabe0a3094d74431988719a))
* Fix tag document type ([#748](https://github.com/squirro/ocbc-ecoffice/issues/748)) ([92232b6](https://github.com/squirro/ocbc-ecoffice/commit/92232b626a2a6aac87df3845c58501833f0bac64))
* Fix timestamp mismatch by using UTC time ([#974](https://github.com/squirro/ocbc-ecoffice/issues/974)) ([596f2f8](https://github.com/squirro/ocbc-ecoffice/commit/596f2f89b3cd99140a9c8982a0f09f2d0491be75))
* Fix title not sanitized in list view ([#837](https://github.com/squirro/ocbc-ecoffice/issues/837)) ([3b46668](https://github.com/squirro/ocbc-ecoffice/commit/3b466683b15debc47ea90567b041cf1ab848f8c3))
* Fix upload form not cleared after document upload ([#851](https://github.com/squirro/ocbc-ecoffice/issues/851)) ([72cfaf4](https://github.com/squirro/ocbc-ecoffice/commit/72cfaf421f66dcd26a9da2b78a17f33a4597f3ac))
* Fix URL for document upload ([#950](https://github.com/squirro/ocbc-ecoffice/issues/950)) ([d73fdcd](https://github.com/squirro/ocbc-ecoffice/commit/d73fdcdb5fa2a1d4c4a0400f5b9d339bc9e79625))
* Fix visibility of delete icon ([#906](https://github.com/squirro/ocbc-ecoffice/issues/906)) ([4f6bc5f](https://github.com/squirro/ocbc-ecoffice/commit/4f6bc5f98daac6a530c99087d52e642c48e3202e))
* Fix WIP dashboard query infinitely appended ([#1055](https://github.com/squirro/ocbc-ecoffice/issues/1055)) ([399dac9](https://github.com/squirro/ocbc-ecoffice/commit/399dac97ccc0659fdd3ee55b1503bc90120313e2))
* Fix word wrapping and breaking ([#1064](https://github.com/squirro/ocbc-ecoffice/issues/1064)) ([2781369](https://github.com/squirro/ocbc-ecoffice/commit/2781369bc94dd86eae9538cd8a5f47d8c791d4f7))
* force ocr to look at first 5 pages only ([#736](https://github.com/squirro/ocbc-ecoffice/issues/736)) ([917ff60](https://github.com/squirro/ocbc-ecoffice/commit/917ff60686e03daa8e8ffad2173c91af5d3dd012))
* Groups not automatically added to dashboards ([#1004](https://github.com/squirro/ocbc-ecoffice/issues/1004)) ([255eee9](https://github.com/squirro/ocbc-ecoffice/commit/255eee91275f2fc3a7fba1bc01f6a9da5cd1c4d2))
* Handle errors/edge cases ([#990](https://github.com/squirro/ocbc-ecoffice/issues/990)) ([782739d](https://github.com/squirro/ocbc-ecoffice/commit/782739d9ffe2c6439e59930189118c7176a342b6))
* Handle item id not in item hash ([#875](https://github.com/squirro/ocbc-ecoffice/issues/875)) ([74bcc8f](https://github.com/squirro/ocbc-ecoffice/commit/74bcc8fe2033af30ee5c2cf868dd303f8ddae109))
* Hide original download icon ([#1025](https://github.com/squirro/ocbc-ecoffice/issues/1025)) ([4cdc210](https://github.com/squirro/ocbc-ecoffice/commit/4cdc210b7d670645bbef3d433eda33e84f2566ed))
* ignore ATx status in batch report ([#1126](https://github.com/squirro/ocbc-ecoffice/issues/1126)) ([16b3644](https://github.com/squirro/ocbc-ecoffice/commit/16b36440dafab5b6c4d907cd408bb2631c5d31b7))
* manually clear session on logout ([#1133](https://github.com/squirro/ocbc-ecoffice/issues/1133)) ([3ba76fd](https://github.com/squirro/ocbc-ecoffice/commit/3ba76fd66a1b38409858c29140179d1969b84fbe))
* mimetype for msg file is unknown ([#982](https://github.com/squirro/ocbc-ecoffice/issues/982)) ([a76962e](https://github.com/squirro/ocbc-ecoffice/commit/a76962ef348aab491dda5643b0411d187dc84a91))
* missing /opt/squirro symlink ([#1091](https://github.com/squirro/ocbc-ecoffice/issues/1091)) ([57d075d](https://github.com/squirro/ocbc-ecoffice/commit/57d075dc10d5596658fdb9bdfb4d4384aa2bdb81))
* missing Document Format label ([#1104](https://github.com/squirro/ocbc-ecoffice/issues/1104)) ([6c05b8e](https://github.com/squirro/ocbc-ecoffice/commit/6c05b8e1cd2cbff872d798761893feda23f0ac4b))
* nginx csp ([#1114](https://github.com/squirro/ocbc-ecoffice/issues/1114)) ([1af1db4](https://github.com/squirro/ocbc-ecoffice/commit/1af1db4f7c11a9885c16f5d4fdb1b7ff2ca7eb05))
* nginx protocol ([#1167](https://github.com/squirro/ocbc-ecoffice/issues/1167)) ([d29ab5b](https://github.com/squirro/ocbc-ecoffice/commit/d29ab5beec2ab2a5039590f945b5d3e1aa9448fe))
* No options for rm names and current status ([#1006](https://github.com/squirro/ocbc-ecoffice/issues/1006)) ([eb33592](https://github.com/squirro/ocbc-ecoffice/commit/eb335922d9e62842fb1e7674fff1e1ba9bf54d0e))
* nvapt 3 ([#1164](https://github.com/squirro/ocbc-ecoffice/issues/1164)) ([16554cf](https://github.com/squirro/ocbc-ecoffice/commit/16554cf9e972f841d6e160a1c01a268ac8d8f220))
* odst-47 check for dual roles ([#951](https://github.com/squirro/ocbc-ecoffice/issues/951)) ([512c58a](https://github.com/squirro/ocbc-ecoffice/commit/512c58a1da9b437a631542d3b8fd6eae9d8e5e5d))
* odst-67 update elastic on doc classified ([#928](https://github.com/squirro/ocbc-ecoffice/issues/928)) ([3644d35](https://github.com/squirro/ocbc-ecoffice/commit/3644d35769fbba2ab77818553d8deef40a6c6aa4))
* optimize performance of bulk assign ([#1065](https://github.com/squirro/ocbc-ecoffice/issues/1065)) ([e3f9d0a](https://github.com/squirro/ocbc-ecoffice/commit/e3f9d0ae09b5bedc86887e4ceeebc4a8b3c35345))
* post install does not clear old folders ([#929](https://github.com/squirro/ocbc-ecoffice/issues/929)) ([c8b67cb](https://github.com/squirro/ocbc-ecoffice/commit/c8b67cb13b18b8f6abd0868420de6883a2a98660))
* postgres deployment issues ([#1127](https://github.com/squirro/ocbc-ecoffice/issues/1127)) ([728a29a](https://github.com/squirro/ocbc-ecoffice/commit/728a29ac4321abd3350c561a83ef42ccdba5232e))
* query template config in topic ([#1113](https://github.com/squirro/ocbc-ecoffice/issues/1113)) ([d15639d](https://github.com/squirro/ocbc-ecoffice/commit/d15639d2bace58d7203314fc40fe220c87849919))
* redis kwargs ([#1157](https://github.com/squirro/ocbc-ecoffice/issues/1157)) ([6cdb049](https://github.com/squirro/ocbc-ecoffice/commit/6cdb049411169e36d6e74b7f1773ae280ff9ac9e))
* redis sentinel ssl args ([#1171](https://github.com/squirro/ocbc-ecoffice/issues/1171)) ([f6fb93f](https://github.com/squirro/ocbc-ecoffice/commit/f6fb93fc1bc88e023eee31612dc91eb8703fb247))
* redis snapshot client init ([#763](https://github.com/squirro/ocbc-ecoffice/issues/763)) ([89e97ac](https://github.com/squirro/ocbc-ecoffice/commit/89e97ac32c4cae80e26de7aa0ecd14a16a0563fa))
* redis snapshot outdated init ([#1096](https://github.com/squirro/ocbc-ecoffice/issues/1096)) ([cc8e684](https://github.com/squirro/ocbc-ecoffice/commit/cc8e684580459f30231045b364aa6b62faafda92))
* removal of thumbnail in store_into_wfi extension independent ([#1027](https://github.com/squirro/ocbc-ecoffice/issues/1027)) ([45a4cb4](https://github.com/squirro/ocbc-ecoffice/commit/45a4cb42a68c93e9f2bbba1311154c9ddf682e68))
* Remove special chars from title ([#903](https://github.com/squirro/ocbc-ecoffice/issues/903)) ([60f037d](https://github.com/squirro/ocbc-ecoffice/commit/60f037daf40d567b6cd55520eaae71846095facc))
* role shown as array in trail ([#959](https://github.com/squirro/ocbc-ecoffice/issues/959)) ([4d7cc66](https://github.com/squirro/ocbc-ecoffice/commit/4d7cc66ac57c8317a0a44350856c47513bdf07e3))
* sentinel set ip var ([#1153](https://github.com/squirro/ocbc-ecoffice/issues/1153)) ([5c8f002](https://github.com/squirro/ocbc-ecoffice/commit/5c8f002ca68c71c76a177bbb0d389a5a8badd6c5))
* Separate icons and text ([#1145](https://github.com/squirro/ocbc-ecoffice/issues/1145)) ([5df1eba](https://github.com/squirro/ocbc-ecoffice/commit/5df1ebabb70c7d6692de60fca25a6c7a468a0aa7))
* Set all initial statuses to 001 ([#1037](https://github.com/squirro/ocbc-ecoffice/issues/1037)) ([ce61974](https://github.com/squirro/ocbc-ecoffice/commit/ce61974900d13383c20818032c878c6a339f0e24))
* set_dashboard_permissions arguments should not contain space ([#1014](https://github.com/squirro/ocbc-ecoffice/issues/1014)) ([fea0241](https://github.com/squirro/ocbc-ecoffice/commit/fea02411cde98a847acdc959e19f558c82a9a267))
* Show column header if empty ([#973](https://github.com/squirro/ocbc-ecoffice/issues/973)) ([b229dff](https://github.com/squirro/ocbc-ecoffice/commit/b229dff27551f0ab38dd394d1f4cd2c45e90549f))
* Show icons by default ([#1038](https://github.com/squirro/ocbc-ecoffice/issues/1038)) ([b8464d3](https://github.com/squirro/ocbc-ecoffice/commit/b8464d301947ec166012499a4c81d2fa2819afd9))
* SIT 3.10.6 deployment fixes ([#1098](https://github.com/squirro/ocbc-ecoffice/issues/1098)) ([7ee53ac](https://github.com/squirro/ocbc-ecoffice/commit/7ee53acad231e6a73913fb0ca780079476db60dc))
* Sort in place ([#1000](https://github.com/squirro/ocbc-ecoffice/issues/1000)) ([2950175](https://github.com/squirro/ocbc-ecoffice/commit/2950175c09a19e3d75495dbb9e19a6e56b5ddf93))
* Specify order in widget config for saving to excel ([#1097](https://github.com/squirro/ocbc-ecoffice/issues/1097)) ([f4b3833](https://github.com/squirro/ocbc-ecoffice/commit/f4b3833ff5eb88ee47b98c3b6af943cc841e8666))
* squirro client no context when trigger from pipelet ([#917](https://github.com/squirro/ocbc-ecoffice/issues/917)) ([8abe7f6](https://github.com/squirro/ocbc-ecoffice/commit/8abe7f68fbb1a8b58c8a9f2bf1a7dbb731977233))
* status tracking mvp1 deployment issues ([#926](https://github.com/squirro/ocbc-ecoffice/issues/926)) ([7b648bd](https://github.com/squirro/ocbc-ecoffice/commit/7b648bdca798a5be5f247fc00d63268fd423297f))
* success email sent during multiple upload ([#1041](https://github.com/squirro/ocbc-ecoffice/issues/1041)) ([4d1eada](https://github.com/squirro/ocbc-ecoffice/commit/4d1eada3b695316f71e8462262550095e5ea93d4))
* text in status trail report overflow ([#958](https://github.com/squirro/ocbc-ecoffice/issues/958)) ([021a88c](https://github.com/squirro/ocbc-ecoffice/commit/021a88ccfb46ce6979ef143a78d3b2ca6c086cfc))
* uat deployment issues ([#933](https://github.com/squirro/ocbc-ecoffice/issues/933)) ([483c6b7](https://github.com/squirro/ocbc-ecoffice/commit/483c6b7e484ecd372d7b1c63a7a39db2afee7560))
* Update config overrides ([#1073](https://github.com/squirro/ocbc-ecoffice/issues/1073)) ([3f4f5d5](https://github.com/squirro/ocbc-ecoffice/commit/3f4f5d5400a97b1cf55ce71ea532999af06786c9))
* update log dir ([#1111](https://github.com/squirro/ocbc-ecoffice/issues/1111)) ([35bd765](https://github.com/squirro/ocbc-ecoffice/commit/35bd765813a74e13176bca47d68de44d7a99a14a))
* Update reader allowed edit keywords ([#908](https://github.com/squirro/ocbc-ecoffice/issues/908)) ([afe3bae](https://github.com/squirro/ocbc-ecoffice/commit/afe3baef1868cbbd0fdce891e7dadd3d8b3b7f82))
* Update reader allowed edit keywords ([#918](https://github.com/squirro/ocbc-ecoffice/issues/918)) ([e480e80](https://github.com/squirro/ocbc-ecoffice/commit/e480e806b468cf34537a870d4b2412b598da3f82))
* upgrade add url ([#1156](https://github.com/squirro/ocbc-ecoffice/issues/1156)) ([1c47e39](https://github.com/squirro/ocbc-ecoffice/commit/1c47e393bf05f250ac5d4d39f86297f4884b79fc))
* upload widget wrong mimetype ([#962](https://github.com/squirro/ocbc-ecoffice/issues/962)) ([d1e6983](https://github.com/squirro/ocbc-ecoffice/commit/d1e6983c2e6ee0257c8cb3f1c6b6070d19c16ecc))
* use `rmcode` ([#1117](https://github.com/squirro/ocbc-ecoffice/issues/1117)) ([00dff9f](https://github.com/squirro/ocbc-ecoffice/commit/00dff9fa08c50fdbf5012b125ef05310eca235a4))
* user roles api timeout when large number of users are added ([#1002](https://github.com/squirro/ocbc-ecoffice/issues/1002)) ([73191ac](https://github.com/squirro/ocbc-ecoffice/commit/73191acdaf36658ae923068c5d2c55a46410b4d9))
* vault db url ([#1063](https://github.com/squirro/ocbc-ecoffice/issues/1063)) ([0a13d95](https://github.com/squirro/ocbc-ecoffice/commit/0a13d9510ec67bde15dadf049cbaf09628333d5a))
* wfi client base url ([#747](https://github.com/squirro/ocbc-ecoffice/issues/747)) ([27321e9](https://github.com/squirro/ocbc-ecoffice/commit/27321e9004c61de1488c9abb478075bdf89f1d63))
* wfi loader read json ([#758](https://github.com/squirro/ocbc-ecoffice/issues/758)) ([6f40c79](https://github.com/squirro/ocbc-ecoffice/commit/6f40c790ba1bfd215b2969dbde44520d357bed55))
* Write reference to wfi ([#835](https://github.com/squirro/ocbc-ecoffice/issues/835)) ([93bcef1](https://github.com/squirro/ocbc-ecoffice/commit/93bcef1d814ed9cfc9facca27a22d7dad5f67f70))
* XLSM not getting ingested ([#1033](https://github.com/squirro/ocbc-ecoffice/issues/1033)) ([fd8ce67](https://github.com/squirro/ocbc-ecoffice/commit/fd8ce677014daf45cb65f3f5bbb8b5ce3e1b0d02))
* zip upload issues ([#1072](https://github.com/squirro/ocbc-ecoffice/issues/1072)) ([b04ad1c](https://github.com/squirro/ocbc-ecoffice/commit/b04ad1c4923ab698cf05383d422ca09a222c1c9d))
* zipfile false positives ([#1119](https://github.com/squirro/ocbc-ecoffice/issues/1119)) ([e4ad54b](https://github.com/squirro/ocbc-ecoffice/commit/e4ad54b56d002b327c0f9d745bc3d5a12725886a))


### Miscellaneous Chores

* release 1.15.0 ([d44a44f](https://github.com/squirro/ocbc-ecoffice/commit/d44a44f94b812107792a6d2937abe68341a99f12))
* release 2.0.0 ([7320a48](https://github.com/squirro/ocbc-ecoffice/commit/7320a482a5770f4a5764045edd1a238558079efe))

## Changelog
