#!/usr/bin/env bash
cd "$(dirname "$0")"
set -e
source ../../common/config/config.sh
source /etc/profile.d/squirro-python.sh

timestamp=$(date +%s)

log_dir="/apps/octopus/logs/wfi_loader/w_periodic"
mkdir -p "${log_dir}"

# Clear logs older than 30 days
# shellcheck disable=SC2038
find "${log_dir}" -type f -mtime +30 | xargs rm -f

if [ $# -eq 0 ]; then
    days_prior=2
else
    days_prior=$1
fi

# Calculate the date
start_date=$(date -d "$days_prior days ago" +%Y%m%d)
end_date="$(date -d 'yesterday' +%Y%m%d)"

# Get the document IDs from the database using java client
echo "Running java client to get json files"
cd "$(getval wfi_client_root wfi)"
mkdir -p "$(getval downloads_dir wfi)"
java -jar "$(getval jar_client wfi)" \
  "${start_date} 160000" \
  "${end_date} 155959" \
  W \
  0
cd -

# Loop through .json and trigger the data loader
echo "Uploading to squirro"
for file in "$(getval wfi_client_root wfi)"/"$(getval downloads_dir wfi)"/*.json; do
    echo "Uploading $file"
    squirro_data_load -v \
        --token "$(getval token squirro)" \
        --cluster "$(getval cluster squirro)" \
        --project-id "$(getval project_id squirro)" \
        --source-name "WFI Periodic W" \
        --source-script "wfi_loader_plugin.py" \
        --pipeline-workflow-name "WFI" \
        --facets-file facets_periodic_w.json \
        --map-id "wfi_document_id" \
        --map-title "filename" \
        --map-body-mime "contentType" \
        --map-file-name "filename" \
        --map-file-data "contentBytes" \
        --map-file-mime "contentType" \
        --json-path "$file" \
        --batch-size 10 \
        --source-batch-size 10 \
      | tee -a "${log_dir}/${timestamp}.log"
    rm "$file"
done
